<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubscriptionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(!Schema::hasTable('subscriptions'))
        {
            Schema::create('subscriptions', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('billable_id');
                $table->string('billable_type');
                $table->string('name');
                $table->integer('paddle_id')->unique();
                $table->string('paddle_status');
                $table->integer('paddle_plan');
                $table->integer('quantity');
                $table->timestamp('trial_ends_at')->nullable();
                $table->timestamp('paused_from')->nullable();
                $table->timestamp('ends_at')->nullable();
                $table->timestamps();

                $table->index(['billable_id', 'billable_type']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
}
