<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(!Schema::hasTable('referral_settings'))
        {
            Schema::create('referral_settings', function (Blueprint $table) {
                $table->id();
                $table->integer('percentage');
                $table->integer('minimum_threshold_amount');
                $table->integer('is_enable')->default(0);
                $table->longText('guideline');
                $table->integer('created_by');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('referral_settings');
    }
};
