<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessLodging;

class LivingAreaSleeping extends \Google\Model
{
  /**
   * @var int
   */
  public $bedsCount;
  /**
   * @var string
   */
  public $bedsCountException;
  /**
   * @var int
   */
  public $bunkBedsCount;
  /**
   * @var string
   */
  public $bunkBedsCountException;
  /**
   * @var int
   */
  public $cribsCount;
  /**
   * @var string
   */
  public $cribsCountException;
  /**
   * @var int
   */
  public $doubleBedsCount;
  /**
   * @var string
   */
  public $doubleBedsCountException;
  /**
   * @var bool
   */
  public $featherPillows;
  /**
   * @var string
   */
  public $featherPillowsException;
  /**
   * @var bool
   */
  public $hypoallergenicBedding;
  /**
   * @var string
   */
  public $hypoallergenicBeddingException;
  /**
   * @var int
   */
  public $kingBedsCount;
  /**
   * @var string
   */
  public $kingBedsCountException;
  /**
   * @var bool
   */
  public $memoryFoamPillows;
  /**
   * @var string
   */
  public $memoryFoamPillowsException;
  /**
   * @var int
   */
  public $otherBedsCount;
  /**
   * @var string
   */
  public $otherBedsCountException;
  /**
   * @var int
   */
  public $queenBedsCount;
  /**
   * @var string
   */
  public $queenBedsCountException;
  /**
   * @var int
   */
  public $rollAwayBedsCount;
  /**
   * @var string
   */
  public $rollAwayBedsCountException;
  /**
   * @var int
   */
  public $singleOrTwinBedsCount;
  /**
   * @var string
   */
  public $singleOrTwinBedsCountException;
  /**
   * @var int
   */
  public $sofaBedsCount;
  /**
   * @var string
   */
  public $sofaBedsCountException;
  /**
   * @var bool
   */
  public $syntheticPillows;
  /**
   * @var string
   */
  public $syntheticPillowsException;

  /**
   * @param int
   */
  public function setBedsCount($bedsCount)
  {
    $this->bedsCount = $bedsCount;
  }
  /**
   * @return int
   */
  public function getBedsCount()
  {
    return $this->bedsCount;
  }
  /**
   * @param string
   */
  public function setBedsCountException($bedsCountException)
  {
    $this->bedsCountException = $bedsCountException;
  }
  /**
   * @return string
   */
  public function getBedsCountException()
  {
    return $this->bedsCountException;
  }
  /**
   * @param int
   */
  public function setBunkBedsCount($bunkBedsCount)
  {
    $this->bunkBedsCount = $bunkBedsCount;
  }
  /**
   * @return int
   */
  public function getBunkBedsCount()
  {
    return $this->bunkBedsCount;
  }
  /**
   * @param string
   */
  public function setBunkBedsCountException($bunkBedsCountException)
  {
    $this->bunkBedsCountException = $bunkBedsCountException;
  }
  /**
   * @return string
   */
  public function getBunkBedsCountException()
  {
    return $this->bunkBedsCountException;
  }
  /**
   * @param int
   */
  public function setCribsCount($cribsCount)
  {
    $this->cribsCount = $cribsCount;
  }
  /**
   * @return int
   */
  public function getCribsCount()
  {
    return $this->cribsCount;
  }
  /**
   * @param string
   */
  public function setCribsCountException($cribsCountException)
  {
    $this->cribsCountException = $cribsCountException;
  }
  /**
   * @return string
   */
  public function getCribsCountException()
  {
    return $this->cribsCountException;
  }
  /**
   * @param int
   */
  public function setDoubleBedsCount($doubleBedsCount)
  {
    $this->doubleBedsCount = $doubleBedsCount;
  }
  /**
   * @return int
   */
  public function getDoubleBedsCount()
  {
    return $this->doubleBedsCount;
  }
  /**
   * @param string
   */
  public function setDoubleBedsCountException($doubleBedsCountException)
  {
    $this->doubleBedsCountException = $doubleBedsCountException;
  }
  /**
   * @return string
   */
  public function getDoubleBedsCountException()
  {
    return $this->doubleBedsCountException;
  }
  /**
   * @param bool
   */
  public function setFeatherPillows($featherPillows)
  {
    $this->featherPillows = $featherPillows;
  }
  /**
   * @return bool
   */
  public function getFeatherPillows()
  {
    return $this->featherPillows;
  }
  /**
   * @param string
   */
  public function setFeatherPillowsException($featherPillowsException)
  {
    $this->featherPillowsException = $featherPillowsException;
  }
  /**
   * @return string
   */
  public function getFeatherPillowsException()
  {
    return $this->featherPillowsException;
  }
  /**
   * @param bool
   */
  public function setHypoallergenicBedding($hypoallergenicBedding)
  {
    $this->hypoallergenicBedding = $hypoallergenicBedding;
  }
  /**
   * @return bool
   */
  public function getHypoallergenicBedding()
  {
    return $this->hypoallergenicBedding;
  }
  /**
   * @param string
   */
  public function setHypoallergenicBeddingException($hypoallergenicBeddingException)
  {
    $this->hypoallergenicBeddingException = $hypoallergenicBeddingException;
  }
  /**
   * @return string
   */
  public function getHypoallergenicBeddingException()
  {
    return $this->hypoallergenicBeddingException;
  }
  /**
   * @param int
   */
  public function setKingBedsCount($kingBedsCount)
  {
    $this->kingBedsCount = $kingBedsCount;
  }
  /**
   * @return int
   */
  public function getKingBedsCount()
  {
    return $this->kingBedsCount;
  }
  /**
   * @param string
   */
  public function setKingBedsCountException($kingBedsCountException)
  {
    $this->kingBedsCountException = $kingBedsCountException;
  }
  /**
   * @return string
   */
  public function getKingBedsCountException()
  {
    return $this->kingBedsCountException;
  }
  /**
   * @param bool
   */
  public function setMemoryFoamPillows($memoryFoamPillows)
  {
    $this->memoryFoamPillows = $memoryFoamPillows;
  }
  /**
   * @return bool
   */
  public function getMemoryFoamPillows()
  {
    return $this->memoryFoamPillows;
  }
  /**
   * @param string
   */
  public function setMemoryFoamPillowsException($memoryFoamPillowsException)
  {
    $this->memoryFoamPillowsException = $memoryFoamPillowsException;
  }
  /**
   * @return string
   */
  public function getMemoryFoamPillowsException()
  {
    return $this->memoryFoamPillowsException;
  }
  /**
   * @param int
   */
  public function setOtherBedsCount($otherBedsCount)
  {
    $this->otherBedsCount = $otherBedsCount;
  }
  /**
   * @return int
   */
  public function getOtherBedsCount()
  {
    return $this->otherBedsCount;
  }
  /**
   * @param string
   */
  public function setOtherBedsCountException($otherBedsCountException)
  {
    $this->otherBedsCountException = $otherBedsCountException;
  }
  /**
   * @return string
   */
  public function getOtherBedsCountException()
  {
    return $this->otherBedsCountException;
  }
  /**
   * @param int
   */
  public function setQueenBedsCount($queenBedsCount)
  {
    $this->queenBedsCount = $queenBedsCount;
  }
  /**
   * @return int
   */
  public function getQueenBedsCount()
  {
    return $this->queenBedsCount;
  }
  /**
   * @param string
   */
  public function setQueenBedsCountException($queenBedsCountException)
  {
    $this->queenBedsCountException = $queenBedsCountException;
  }
  /**
   * @return string
   */
  public function getQueenBedsCountException()
  {
    return $this->queenBedsCountException;
  }
  /**
   * @param int
   */
  public function setRollAwayBedsCount($rollAwayBedsCount)
  {
    $this->rollAwayBedsCount = $rollAwayBedsCount;
  }
  /**
   * @return int
   */
  public function getRollAwayBedsCount()
  {
    return $this->rollAwayBedsCount;
  }
  /**
   * @param string
   */
  public function setRollAwayBedsCountException($rollAwayBedsCountException)
  {
    $this->rollAwayBedsCountException = $rollAwayBedsCountException;
  }
  /**
   * @return string
   */
  public function getRollAwayBedsCountException()
  {
    return $this->rollAwayBedsCountException;
  }
  /**
   * @param int
   */
  public function setSingleOrTwinBedsCount($singleOrTwinBedsCount)
  {
    $this->singleOrTwinBedsCount = $singleOrTwinBedsCount;
  }
  /**
   * @return int
   */
  public function getSingleOrTwinBedsCount()
  {
    return $this->singleOrTwinBedsCount;
  }
  /**
   * @param string
   */
  public function setSingleOrTwinBedsCountException($singleOrTwinBedsCountException)
  {
    $this->singleOrTwinBedsCountException = $singleOrTwinBedsCountException;
  }
  /**
   * @return string
   */
  public function getSingleOrTwinBedsCountException()
  {
    return $this->singleOrTwinBedsCountException;
  }
  /**
   * @param int
   */
  public function setSofaBedsCount($sofaBedsCount)
  {
    $this->sofaBedsCount = $sofaBedsCount;
  }
  /**
   * @return int
   */
  public function getSofaBedsCount()
  {
    return $this->sofaBedsCount;
  }
  /**
   * @param string
   */
  public function setSofaBedsCountException($sofaBedsCountException)
  {
    $this->sofaBedsCountException = $sofaBedsCountException;
  }
  /**
   * @return string
   */
  public function getSofaBedsCountException()
  {
    return $this->sofaBedsCountException;
  }
  /**
   * @param bool
   */
  public function setSyntheticPillows($syntheticPillows)
  {
    $this->syntheticPillows = $syntheticPillows;
  }
  /**
   * @return bool
   */
  public function getSyntheticPillows()
  {
    return $this->syntheticPillows;
  }
  /**
   * @param string
   */
  public function setSyntheticPillowsException($syntheticPillowsException)
  {
    $this->syntheticPillowsException = $syntheticPillowsException;
  }
  /**
   * @return string
   */
  public function getSyntheticPillowsException()
  {
    return $this->syntheticPillowsException;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LivingAreaSleeping::class, 'Google_Service_MyBusinessLodging_LivingAreaSleeping');
